/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.model.ITransformation;
import org.lwjgl.util.vector.Vector3f;

public class ModelUtils {
    public static float[] getUVs(AxisAlignedBB box, EnumFacing face) {
        switch (face) {
            default: {
                return new float[]{(float)box.field_72340_a, 16.0f - (float)box.field_72339_c, (float)box.field_72336_d, 16.0f - (float)box.field_72334_f};
            }
            case UP: {
                return new float[]{(float)box.field_72340_a, (float)box.field_72339_c, (float)box.field_72336_d, (float)box.field_72334_f};
            }
            case NORTH: {
                return new float[]{16.0f - (float)box.field_72336_d, (float)box.field_72338_b, 16.0f - (float)box.field_72340_a, (float)box.field_72337_e};
            }
            case SOUTH: {
                return new float[]{(float)box.field_72340_a, (float)box.field_72338_b, (float)box.field_72336_d, (float)box.field_72337_e};
            }
            case WEST: {
                return new float[]{(float)box.field_72339_c, (float)box.field_72338_b, (float)box.field_72334_f, (float)box.field_72337_e};
            }
            case EAST: 
        }
        return new float[]{16.0f - (float)box.field_72334_f, (float)box.field_72338_b, 16.0f - (float)box.field_72339_c, (float)box.field_72337_e};
    }

    public static int getFaceAngle(EnumFacing.Axis axis, EnumFacing face) {
        if (axis == EnumFacing.Axis.Y) {
            return 0;
        }
        if (axis == EnumFacing.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
                case NORTH: {
                    return 270;
                }
            }
            return 90;
        }
        return face == EnumFacing.NORTH ? 270 : 90;
    }

    public static float[] modUV(float[] uvs) {
        uvs[0] = (int)uvs[0] & 0xF;
        uvs[1] = (int)uvs[1] & 0xF;
        uvs[2] = ((int)uvs[2] - 1 & 0xF) + 1;
        uvs[3] = ((int)uvs[3] - 1 & 0xF) + 1;
        return uvs;
    }

    public static Vector3f[] AABBLimits(AxisAlignedBB aabb) {
        return new Vector3f[]{new Vector3f((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c), new Vector3f((float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f)};
    }

    public static BakedQuad makeBakedQuad(BlockPart blockPart, BlockPartFace partFace, TextureAtlasSprite atlasSprite, EnumFacing dir, ITransformation transform, boolean uvlocked) {
        return new FaceBakery().makeBakedQuad(blockPart.field_178241_a, blockPart.field_178239_b, partFace, atlasSprite, dir, transform, blockPart.field_178237_d, uvlocked, blockPart.field_178238_e);
    }
}

